/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.CharChunk;

public final class StringCache {
    private static final Logger logger = Grizzly.logger(StringCache.class);
    static boolean byteEnabled = "true".equals(System.getProperty("tomcat.util.buf.StringCache.byte.enabled", "false"));
    static boolean charEnabled = "true".equals(System.getProperty("tomcat.util.buf.StringCache.char.enabled", "false"));
    static int trainThreshold = Integer.parseInt(System.getProperty("tomcat.util.buf.StringCache.trainThreshold", "20000"));
    static int cacheSize = Integer.parseInt(System.getProperty("tomcat.util.buf.StringCache.cacheSize", "200"));
    static final HashMap<ByteEntry, int[]> bcStats = new HashMap(cacheSize);
    static int bcCount = 0;
    static ByteEntry[] bcCache = null;
    static final HashMap<CharEntry, int[]> ccStats = new HashMap(cacheSize);
    static int ccCount = 0;
    static CharEntry[] ccCache = null;
    static int accessCount = 0;
    static int hitCount = 0;

    public static int getCacheSize() {
        return cacheSize;
    }

    public static void setCacheSize(int cacheSize) {
        StringCache.cacheSize = cacheSize;
    }

    public static boolean getByteEnabled() {
        return byteEnabled;
    }

    public static void setByteEnabled(boolean byteEnabled) {
        StringCache.byteEnabled = byteEnabled;
    }

    public static boolean getCharEnabled() {
        return charEnabled;
    }

    public static void setCharEnabled(boolean charEnabled) {
        StringCache.charEnabled = charEnabled;
    }

    public static int getTrainThreshold() {
        return trainThreshold;
    }

    public static void setTrainThreshold(int trainThreshold) {
        StringCache.trainThreshold = trainThreshold;
    }

    public static int getAccessCount() {
        return accessCount;
    }

    public static int getHitCount() {
        return hitCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        hitCount = 0;
        accessCount = 0;
        HashMap<Object, int[]> hashMap = bcStats;
        synchronized (hashMap) {
            bcCache = null;
            bcCount = 0;
        }
        hashMap = ccStats;
        synchronized (hashMap) {
            ccCache = null;
            ccCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(ByteChunk bc) {
        if (bcCache == null) {
            String value2 = bc.toStringInternal();
            if (byteEnabled) {
                HashMap<ByteEntry, int[]> hashMap = bcStats;
                synchronized (hashMap) {
                    if (bcCache != null) {
                        return value2;
                    }
                    if (bcCount > trainThreshold) {
                        long t1 = System.currentTimeMillis();
                        TreeMap<Integer, ArrayList<ByteEntry>> tempMap = new TreeMap<Integer, ArrayList<ByteEntry>>();
                        for (ByteEntry entry2 : bcStats.keySet()) {
                            int[] countA = bcStats.get(entry2);
                            Integer count2 = countA[0];
                            ArrayList<ByteEntry> list2 = (ArrayList<ByteEntry>)tempMap.get(count2);
                            if (list2 == null) {
                                list2 = new ArrayList<ByteEntry>();
                                tempMap.put(count2, list2);
                            }
                            list2.add(entry2);
                        }
                        int size2 = bcStats.size();
                        if (size2 > cacheSize) {
                            size2 = cacheSize;
                        }
                        ByteEntry[] tempbcCache = new ByteEntry[size2];
                        ByteChunk tempChunk = new ByteChunk();
                        int n = 0;
                        while (n < size2) {
                            Object key = tempMap.lastKey();
                            ArrayList list3 = (ArrayList)tempMap.get(key);
                            for (int i = 0; i < list3.size() && n < size2; ++n, ++i) {
                                ByteEntry entry3 = (ByteEntry)list3.get(i);
                                tempChunk.setBytes(entry3.name, 0, entry3.name.length);
                                int insertPos = StringCache.findClosest(tempChunk, tempbcCache, n);
                                if (insertPos == n) {
                                    tempbcCache[n + 1] = entry3;
                                    continue;
                                }
                                System.arraycopy(tempbcCache, insertPos + 1, tempbcCache, insertPos + 2, n - insertPos - 1);
                                tempbcCache[insertPos + 1] = entry3;
                            }
                            tempMap.remove(key);
                        }
                        bcCount = 0;
                        bcStats.clear();
                        bcCache = tempbcCache;
                        if (logger.isLoggable(Level.FINEST)) {
                            long t2 = System.currentTimeMillis();
                            logger.log(Level.FINEST, "ByteCache generation time: " + (t2 - t1) + "ms");
                        }
                    } else {
                        ++bcCount;
                        ByteEntry entry4 = new ByteEntry();
                        entry4.value = value2;
                        int[] count3 = bcStats.get(entry4);
                        if (count3 == null) {
                            int end = bc.getEnd();
                            int start = bc.getStart();
                            entry4.name = new byte[bc.getLength()];
                            System.arraycopy(bc.getBuffer(), start, entry4.name, 0, end - start);
                            entry4.charset = bc.getCharset();
                            count3 = new int[]{1};
                            bcStats.put(entry4, count3);
                        } else {
                            count3[0] = count3[0] + 1;
                        }
                    }
                }
            }
            return value2;
        }
        ++accessCount;
        String result2 = StringCache.find(bc);
        if (result2 == null) {
            return bc.toStringInternal();
        }
        ++hitCount;
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(CharChunk cc) {
        if (ccCache == null) {
            String value2 = cc.toStringInternal();
            if (charEnabled) {
                HashMap<CharEntry, int[]> hashMap = ccStats;
                synchronized (hashMap) {
                    if (ccCache != null) {
                        return value2;
                    }
                    if (ccCount > trainThreshold) {
                        long t1 = System.currentTimeMillis();
                        TreeMap<Integer, ArrayList<CharEntry>> tempMap = new TreeMap<Integer, ArrayList<CharEntry>>();
                        for (CharEntry entry2 : ccStats.keySet()) {
                            int[] countA = ccStats.get(entry2);
                            Integer count2 = countA[0];
                            ArrayList<CharEntry> list2 = (ArrayList<CharEntry>)tempMap.get(count2);
                            if (list2 == null) {
                                list2 = new ArrayList<CharEntry>();
                                tempMap.put(count2, list2);
                            }
                            list2.add(entry2);
                        }
                        int size2 = ccStats.size();
                        if (size2 > cacheSize) {
                            size2 = cacheSize;
                        }
                        CharEntry[] tempccCache = new CharEntry[size2];
                        CharChunk tempChunk = new CharChunk();
                        int n = 0;
                        while (n < size2) {
                            Object key = tempMap.lastKey();
                            ArrayList list3 = (ArrayList)tempMap.get(key);
                            for (int i = 0; i < list3.size() && n < size2; ++n, ++i) {
                                CharEntry entry3 = (CharEntry)list3.get(i);
                                tempChunk.setChars(entry3.name, 0, entry3.name.length);
                                int insertPos = StringCache.findClosest(tempChunk, tempccCache, n);
                                if (insertPos == n) {
                                    tempccCache[n + 1] = entry3;
                                    continue;
                                }
                                System.arraycopy(tempccCache, insertPos + 1, tempccCache, insertPos + 2, n - insertPos - 1);
                                tempccCache[insertPos + 1] = entry3;
                            }
                            tempMap.remove(key);
                        }
                        ccCount = 0;
                        ccStats.clear();
                        ccCache = tempccCache;
                        if (logger.isLoggable(Level.FINEST)) {
                            long t2 = System.currentTimeMillis();
                            logger.log(Level.FINEST, "CharCache generation time: " + (t2 - t1) + "ms");
                        }
                    } else {
                        ++ccCount;
                        CharEntry entry4 = new CharEntry();
                        entry4.value = value2;
                        int[] count3 = ccStats.get(entry4);
                        if (count3 == null) {
                            int end = cc.getEnd();
                            int start = cc.getStart();
                            entry4.name = new char[cc.getLength()];
                            System.arraycopy(cc.getBuffer(), start, entry4.name, 0, end - start);
                            count3 = new int[]{1};
                            ccStats.put(entry4, count3);
                        } else {
                            count3[0] = count3[0] + 1;
                        }
                    }
                }
            }
            return value2;
        }
        ++accessCount;
        String result2 = StringCache.find(cc);
        if (result2 == null) {
            return cc.toStringInternal();
        }
        ++hitCount;
        return result2;
    }

    protected static int compare(ByteChunk name, byte[] compareTo) {
        int len;
        int result2 = 0;
        byte[] b = name.getBuffer();
        int start = name.getStart();
        int end = name.getEnd();
        if (end - start < (len = compareTo.length)) {
            len = end - start;
        }
        for (int i = 0; i < len && result2 == 0; ++i) {
            if (b[i + start] > compareTo[i]) {
                result2 = 1;
                continue;
            }
            if (b[i + start] >= compareTo[i]) continue;
            result2 = -1;
        }
        if (result2 == 0) {
            if (compareTo.length > end - start) {
                result2 = -1;
            } else if (compareTo.length < end - start) {
                result2 = 1;
            }
        }
        return result2;
    }

    protected static String find(ByteChunk name) {
        int pos = StringCache.findClosest(name, bcCache, bcCache.length);
        if (pos < 0 || StringCache.compare(name, StringCache.bcCache[pos].name) != 0 || !name.getCharset().equals(StringCache.bcCache[pos].charset)) {
            return null;
        }
        return StringCache.bcCache[pos].value;
    }

    protected static int findClosest(ByteChunk name, ByteEntry[] array, int len) {
        int a = 0;
        int b = len - 1;
        if (b == -1) {
            return -1;
        }
        if (StringCache.compare(name, array[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        do {
            int i = b + a >>> 1;
            int result2 = StringCache.compare(name, array[i].name);
            if (result2 == 1) {
                a = i;
                continue;
            }
            if (result2 == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = StringCache.compare(name, array[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    protected static int compare(CharChunk name, char[] compareTo) {
        int len;
        int result2 = 0;
        char[] c = name.getBuffer();
        int start = name.getStart();
        int end = name.getEnd();
        if (end - start < (len = compareTo.length)) {
            len = end - start;
        }
        for (int i = 0; i < len && result2 == 0; ++i) {
            if (c[i + start] > compareTo[i]) {
                result2 = 1;
                continue;
            }
            if (c[i + start] >= compareTo[i]) continue;
            result2 = -1;
        }
        if (result2 == 0) {
            if (compareTo.length > end - start) {
                result2 = -1;
            } else if (compareTo.length < end - start) {
                result2 = 1;
            }
        }
        return result2;
    }

    protected static String find(CharChunk name) {
        int pos = StringCache.findClosest(name, ccCache, ccCache.length);
        if (pos < 0 || StringCache.compare(name, StringCache.ccCache[pos].name) != 0) {
            return null;
        }
        return StringCache.ccCache[pos].value;
    }

    protected static int findClosest(CharChunk name, CharEntry[] array, int len) {
        int a = 0;
        int b = len - 1;
        if (b == -1) {
            return -1;
        }
        if (StringCache.compare(name, array[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        do {
            int i = b + a >>> 1;
            int result2 = StringCache.compare(name, array[i].name);
            if (result2 == 1) {
                a = i;
                continue;
            }
            if (result2 == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = StringCache.compare(name, array[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    protected static class CharEntry {
        public char[] name = null;
        public String value = null;

        protected CharEntry() {
        }

        public String toString() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof CharEntry && this.value.equals(((CharEntry)obj).value);
        }
    }

    protected static class ByteEntry {
        public byte[] name = null;
        public Charset charset = null;
        public String value = null;

        protected ByteEntry() {
        }

        public String toString() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ByteEntry && this.value.equals(((ByteEntry)obj).value);
        }
    }
}

